#include "OneUp.h"



OneUp::OneUp()
{
	spriteType = SpriteType::OneUpSprite;

	moveableTexture.loadFromFile("Assets/Sprites/Moveables/oneUp.png");	//Load the one up texture
	setTexture(&moveableTexture);
	setCollisionBox(0, 0, 50, 50);
	setSize(sf::Vector2f(50, 50));
	setVelocity(125, 0);	//Have the one up move toward the right initially
}


OneUp::~OneUp()
{
}

void OneUp::handleCollision(MySprite* sprite, float dt)
{
	//Only Mario can possible collide, so it's safe to assume and cast the MySprite object to a Mario object
	Mario* mario = (Mario*)sprite;	//Cast to access Mario specific functions
	setAlive(false);	//Kill the one up
	mario->addLife();	//Add a life to Mario due to the one up collision
}
